---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
---

# Resonance (dynamic)

> Constructive phase alignment; amplification within safe windows set by anchors and SVA.

---

## Definition

- Phase alignment increases amplitude
- Energy transfer within bounds
- Stable reinforcement pattern
- Controlled amplification

---

## Dual‑register mapping

### Technical (network/computational)

| Diagnostic concept | Network construct | Test example |
|-------------------|------------------|--------------|
| Phase lock | Clock sync | `Monitor`, `Lock` |
| Amplification | Gain control | `Check`, `Gain` |
| Stability | Margin test | `Test`, `Margin` |

### Humane (biological/relational)

| Diagnostic concept | Humane construct | Example |
|-------------------|------------------|----------|
| Phase lock | Natural rhythm | "In sync" |
| Amplification | Growing energy | "Building up" |
| Stability | Safe growth | "Stays strong" |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| Clock sync | Natural rhythm | How timing aligns |
| Gain control | Growing energy | How strength builds |
| Margin test | Safe growth | How stability holds |

### Domain Examples

| Domain | Technical test | Humane test |
|--------|---------------|-------------|
| Physics | Oscillator | Natural frequency |
| Networks | Protocol sync | Living rhythm |
| Cognition | Neural sync | Flow state |
| Systems | State resonance | Natural harmony |

---

## Scale Effects

How Resonance manifests differently at various scales:

### Micro Scale (ε-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ε | Phase quantum | Wave sync |
| λV | Gate resonance | State lock |

### Human Scale (ψA-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ψA | Phase binding | Attention lock |
| ∇S | Pattern clarity | Clear rhythm |

### Cosmic Scale (c-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| c | Wave limit | Light sync |
| λV | Field resonance | Space harmony |

Note: At extreme scales, resonance faces fundamental limits (e.g., quantum coherence at ε, causal synchronization at c).

---

## Invariants / Thresholds

Scale-dependent bounds:
- ε: phase resolution met
- c: amplitude bounded
- π: phase geometry stable
- λV: gates aligned

---

## SVA Coupling

Scale-dependent modulator effects:

| Scale | Modulator | Technical effect | Humane effect |
|-------|-----------|-----------------|---------------|
| Micro | ∇S | Pattern lock | Wave clarity |
| Human | λV | Gate resonance | Flow control |
| Cosmic | ψA | Phase harmony | Field binding |

---

## Failure Modes

Scale-dependent failure patterns:

| Scale | Mode | Technical signature | Humane signature |
|-------|------|-------------------|------------------|
| Micro | Over-lock | Pattern break | Lost freedom |
| Human | Over-amp | Growth runaway | Out of control |
| Cosmic | Field break | Structure loss | Lost harmony |

---

## Diagnostic Checklist

Technical tests:
- [ ] Phase error bounded
- [ ] Amplitude controlled
- [ ] Margins sufficient
- [ ] Lock maintained

Humane tests:
- [ ] Rhythm natural
- [ ] Growth healthy
- [ ] Balance kept
- [ ] Flow smooth

---

## Design rationale

This diagnostic must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical resonance nor experiential harmony alone captures its full meaning.

---

## See Also

- [[Interference (dynamic)]]
- [[Harmony (dynamic)]]
- [[Dissonance (dynamic)]]
- [[Form]]
- [[Field]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale-aware tests documented